<?php
session_start();

// Verificar si el usuario está logueado y tiene permisos para ver esta página
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: dashboard.php');
    exit;
}

// Conectar a la base de datos
require_once '../conexiones/conexion.php';

// Procesar la acción de agregar un nuevo cliente
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_client'])) {
    $dni = $_POST['dni'];
    $nombre = $_POST['nombre'];
    $correo = $_POST['correo'];
    $telefono = $_POST['telefono'];
    $direccion = $_POST['direccion'];
echo $direccion;
    try {
        // Insertar el nuevo cliente en la base de datos
        $stmt = $pdo->prepare("INSERT INTO clientes (nombre, dni, correo, direccion, telefono) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$nombre, $dni, $correo, $direccion, $telefono]);

        // Redirigir a la página de gestión de clientes con un mensaje de éxito
        header('Location: ../clientes.php');
        exit;
    } catch (PDOException $e) {
        // Redirigir con un mensaje de error si ocurre un problema
        header('Location: ../clientes.php');
        exit;
    }
} else {
    // Si se accede directamente al archivo sin enviar datos
    header('Location: clientes.php');
    exit;
}
?>
